<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="COCT_MT090100NL" see="http://wiki.hl7.org/index.php?title=Implementatiehandleiding_HL7v3_basiscomponenten_v2.2_Part3#CMET_R_AssignedPersonUniversal">
    <title>R_AssignedPersonNL universal</title>
    <rule context="$element">
        <assert role="error" test="not(@classCode) or @classCode='ASSIGNED'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#ASSIGNED"
            >COCT_MT090100NL: @classCode moet indien aanwezig 'ASSIGNED' zijn</assert>
    </rule>
    <rule context="$element/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    <rule context="$element/hl7:certificateText">
        <extends rule="ED"/>
    </rule>
    
    <rule context="$element/hl7:assignedPerson/hl7:name">
        <extends rule="EN"/>
    </rule>
    
    <rule context="$element/hl7:Organization/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:name">
        <extends rule="ON"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:desc">
        <extends rule="ED"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:Organization/hl7:standardIndustryClassCode">
        <extends rule="CE"/>
    </rule>
</pattern>